function [c, LandUseChange, GISheader, LURNZDATA, forestHR ] = LUAM1_load_data(pixel_size, last_year, output_path )
%
% Land Use Allocation Module - function 1 (LUAM1)
%
% This file loads the vectorized map of land use for LURNZ. This map will
% be used to spatially allocate changes in land use.
%
% The preparation of the vectorized map is handled outside of LURNZ in a
% map setup function.

% Code by Simon Anastasiadis : 2011-11-03

%% Parameters

% first simulation year
start_year = 2009;

% path for data
load_path = '..\Data for Modules\Data 2 Land Use Allocation Module';
% path for land use change
LUCM_path = [output_path, '\Results 1 Land Use Change Module'];

% We load coefficients (currently) attributed to Wei Zhang. These
% coefficients are drawn from the previous release of LURNZ.
%
% loading forestry harvest & replant (HR) coefficients
HR_coef_file = '\coefficients Zhang 2009.xls';
% forestry HR sheet names
HR_sheet = 'Sheet1';
% forestry HR coefficient ranges
HR_harvest_ed_able_ratio = 'A4';
HR_harvest_by_age = 'A8:B14';
HR_percent_replace = 'A17';

%% Place holders for variables that will be loaded

LURNZDATA = [];
output_change = [];
c = [];
GISheader = [];

%% Load Land Use Change Module Output

load([LUCM_path,'\LUCM_output_data'])

%% Arrange Land Use Change Module Output for Land Use Allocation Module

% Keep only those years we are interested in
iYear = last_year >= output_change(:,1) & output_change(:,1) >= start_year;
LandUseChange = output_change(iYear,:);

% Scale to changes in pixels
LandUseChange(:,2:end) = LandUseChange(:,2:end) / pixel_size;

% Round
LandUseChange(:,2:end) = round( LandUseChange(:,2:end) );

% Ensure sum of changes = 0
% i.e. set dScrub = -(dDairy + dSheep + dForest)
LandUseChange(:,5) = -sum( LandUseChange(:,2:4) , 2);
% by construction this should result in at most 2 pixels change in dScrub

%% Load GIS data

load([load_path,'\LUAM_input_data_',num2str(pixel_size),'ha']);

%% Assert correct variables loaded

msg = sprintf(['Error in LUAM1_load_data\n'...
               'Not all required variables loaded']);

assert(exist('c','var')        ==1, msg);
assert(exist('LURNZDATA','var')==1, msg);
assert(exist('GISheader','var')==1, msg);

%% Load Forestry coefficients

% these coefficients govern forestry harvest and replanting
forestHR.harvest_ed_able_ratio = xlsread([load_path,HR_coef_file],HR_sheet,HR_harvest_ed_able_ratio);
forestHR.harvest_by_age        = xlsread([load_path,HR_coef_file],HR_sheet,HR_harvest_by_age);
forestHR.percent_replace       = xlsread([load_path,HR_coef_file],HR_sheet,HR_percent_replace);

%% Inform User loading data is complete

msg = sprintf(' - - LUAM1 : loading data complete');
disp(msg)

end
